<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_aigne', language 'es', version '3.11'.
 *
 * @package     theme_aigne
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessibility'] = 'accesibilidad';
$string['accessibilitydesc'] = 'Si activa esta opción, aparecerá un enlace en el pié de página a la información sobre accesibilidad de la plataforma';
$string['accessibilitypage'] = '<h2 style="text-align: center">Esta es una página de muestra</h2>
<p>&nbsp;</p>
<h2>Accesibilidad</h2>
<p>Aquí puede introducir las herramientas que estan instaladas en el sitio web para
   facilitar la navegación a personas con dificultades visuales o mobilidad reducida.</p>
<h2>Parámetros que se pasan:</h2>
  <ul>{$a->supportemail}</ul>
  <ul>{$a->sendadminemail}</ul>
  <p>&nbsp;</p>';
$string['afternoon_greeting'] = 'Buenas tardes... !';
$string['backbody'] = 'Fondo de la página';
$string['backbodydesc'] = 'Si lo desea puede añadir una imagen que aparecerá en el fondo de la página.<br />
Debe ser una imagen JPG/PNG/GIF y según el tamaño, debe configurar la siguiente opción.';
$string['backcolor'] = 'Color del fondo';
$string['backcolordesc'] = 'Si lo desea puede configurar un color de fondo, en lugar de imponer una imagen.<br />
Si desea mantener el color original, seleccione el blanco o escriba #FFFFFF.';
$string['backlogo'] = 'Fondo del logotipo';
$string['backlogodesc'] = 'Si lo desea puede añadir una imagen de fondo para el logotipo.<br />
Debe ser una imagen JPG/PNG/GIF con 200px de largo y 75px de alto';
$string['bcsep'] = 'Separador de la Barra de Navegación';
$string['bcsep1'] = 'Flecha convencional ( ► )';
$string['bcsep2'] = 'Comillas Latinas de cierre ( » )';
$string['bcsep3'] = 'Línea vertical ( | )';
$string['bcsep4'] = 'Barra inclinada ( / )';
$string['bcsep5'] = 'Guión bajo ( _ )';
$string['bcsep6'] = 'Varios dos puntos ( ::: )';
$string['bcsep7'] = 'Espacio en blanco ( &nbsp; )';
$string['bcsepdesc'] = 'Seleccione el tipo de separador que se debe usar en la Barra de Navegación.';
$string['bgposition'] = 'Posición del fondo';
$string['bgpositiondesc'] = 'Al configurar la opción anterior, dependiendo del tipo de imagen, puede configurar su comportamiento, seleccionando si se repite, y en que dirección.';
$string['blogger'] = 'Enlace a Blogger';
$string['bloggerdesc'] = 'Introduzca el enlace (URL) a su blog en Blogger.
<a href="http://www.blogger.com/" target="_blank"> (www.blogger.com) .</a>';
$string['bodyfont'] = 'Tamaño de fuente';
$string['bodyfontdesc'] = 'Si lo desea puede configurar un tamaño de letra como referencia. Tenga cuidado con los tamaños de letra mas grandes o mas pequeños, ya que es sabido que causan problemas en algunos bloques, pruébelo y decida';
$string['bottomphead'] = 'Configuración del Pié de Página';
$string['breadcrumbhead'] = 'Opciones de la Barra de navegación';
$string['choosereadme'] = '<div class="clearfix">
  <div class="theme_screenshot">

    <h2>aigne</h2>
    <img src="aigne/pix/screenshot.jpg" />

    <h3>Forum de Divulgación:</h3>
    <p><a href="http://moodle.org/mod/forum/view.php?id=46">http://moodle.org/mod/forum/view.php?id=46</a></p>

    <h3>Documentación:</h3>
    <p><a href="http://docs.moodle.org/all/es/admin/setting/themesettingaigne">Documentación oficial del tema Aigne</a></p>

    <h3>Para informar incidencias:</h3>
    <p>Enviar un eMail a francpombal@hotmail.com</p>
  </div>

  <div class="theme_description">
    <h3>Acerca de:</h3>
    <p>Tema para Moodle 2.x y 3.0 _ Principales características:</p>
    <ul>
      <li>Diseño simple, totalmente compatible con CSS y adaptativo a diversos tamaños de pantalla.
      <li>Solo utiliza 5 tonalidades del color principal, también con esquemas predeterminados de color.
      <li>Opciones de @font-face, para elegir entre 3 tipos de letra incluidas.
      <li>Logotipo, lema del sitio y una imagen de fondo del logotipo.
      <li>Nuevas opciones para las etiquetas META del header (herramientas SEO).
      <li>Página principal con zonas para banner, información de marketing o imagenes, totalmente personalizable.
      <li>Area de Información del Usuario, que puede ser mostrada en el encabezado o en el bloque de navegación.
      <li>Sección NavHelp con todos los enlaces administrativos requeridos a páginas personalizables según el idioma
      (mapa web, ayuda, búsqueda, estadísticas, aviso legal, politicas del sitio, privacidad, seguridad y accesibilidad)
      <li>Sección de Contacto, con la adaptación de 30 enlaces a redes sociales y herramientas web.
      <li>Sección de Derechos de propiedad intelectual y Créditos, con opciones para la validación externa en los servidores w3c
      <br />
      <li>Más de 100 opciones de personalización en Administración del sitio -> Apariencia -> Temas -> AIGNE.
    </ul>
    <h3>Créditos:</h3>
    <p>Design created by Franc Pombal (www.aigne.com), after improving the AfterBurner Theme in the Moodle core.</p>
    <h3>Licencia:</h3>
    <p>This, and all other themes included in the Moodle core, are licensed under the <a href="http://www.gnu.org/licenses/gpl.html">GNU General Public License</a>.</p>
  </div>
</div>';
$string['colorsch'] = 'Esquema de color del sitio.';
$string['colorschdesc'] = 'Seleccione el esquema de color que se usará de forma predeterminado. [The design still unfinished] <br />
    <table class="headerop" Style="width: 275px; border: 2px solid #322C65;">
        <tr Style="height:25px">
            <td Style="background-color:#322C65">&nbsp;</td>
            <td Style="background-color:#007EBA">&nbsp;</td>
            <td Style="background-color:#CCDDEE">&nbsp;</td>
            <td Style="background-color:#F3F7FF">&nbsp;</td>
            <td Style="background-color:#FFFFFF">{$a->css_color1}</td>
            <td Style="background-color:#FFFFFF; color:#3C3C3C">A</td>
        </tr>
        <tr Style="height:25px">
            <td Style="background-color:#F3F7FF">&nbsp;</td>
            <td Style="background-color:#CCDDEE">&nbsp;</td>
            <td Style="background-color:#322C65">&nbsp;</td>
            <td Style="background-color:#000033">&nbsp;</td>
            <td Style="background-color:#FFFFFF">{$a->css_color2}</td>
            <td Style="background-color:#000033; color:#FFFFFF">A</td>
        </tr>
        <tr Style="height:25px">
            <td Style="background-color:#001A1A">&nbsp;</td>
            <td Style="background-color:#004040">&nbsp;</td>
            <td Style="background-color:#4CA9BC">&nbsp;</td>
            <td Style="background-color:#F2FFEB">&nbsp;</td>
            <td Style="background-color:#FFFFFF">{$a->css_color3}</td>
            <td Style="background-color:#FFFFFF; color:#3C3C3C">A</td>
        </tr>
        <tr Style="height:25px">
            <td Style="background-color:#522500">&nbsp;</td>
            <td Style="background-color:#EB8324">&nbsp;</td>
            <td Style="background-color:#F6CC87">&nbsp;</td>
            <td Style="background-color:#FFFFCC">&nbsp;</td>
            <td Style="background-color:#FFFFFF">{$a->css_color4}</td>
            <td Style="background-color:#FFFFFF; color:#3C3C3C">A</td>
        </tr>
        <tr Style="height:25px">
            <td Style="width:25px; background-color:#520000">&nbsp;</td>
            <td Style="width:25px; background-color:#AA0000">&nbsp;</td>
            <td Style="width:25px; background-color:#F1A78E">&nbsp;</td>
            <td Style="width:25px; background-color:#FFF2F2">&nbsp;</td>
            <td Style="width:150px; background-color:#FFFFFF">{$a->css_color5}</td>
            <td Style="width:25px; background-color:#FFFFFF; color:#3C3C3C">A</td>
        </tr>
    </table>';
$string['compatcredit'] = 'Compatibilidades';
$string['compatcreditdesc'] = 'Si desea que aparezca en el pié de página una lista con los logotipos de las distintas validaciones conseguidas, active esta opción';
$string['compattested'] = 'Compatibilidades Validadas';
$string['compattesteddesc'] = 'Seleccione los logotipos que desea mostrar, teniendo en cuenta que usted haya validado su Web, bajo su responsabilidad';
$string['compatwai'] = 'Validación de Accesibilidad';
$string['compatwai1'] = 'Todavia sin testear';
$string['compatwai2'] = 'Nivel A';
$string['compatwai3'] = 'Nivel AA';
$string['compatwai4'] = 'Nivel AAA';
$string['compatwaidesc'] = 'Seleccione el logotipo de accesibilidad que desea mostrar, teniendo en cuenta que usted haya validado su Web, bajo su responsabilidad.
<a href="http://www.w3.org/WAI/WCAG1AAA-Conformance" target="_blank"> (WAI WCAG AAA) .</a>';
$string['configtitle'] = 'Configuración personalizada de aigne';
$string['contacthead'] = 'Opciones de contacto';
$string['contactnote'] = 'Contacto';
$string['contactnotedesc'] = 'Aquí puede añadir información de contacto que aparecerá en medio de la zona de contacto del pié de página';
$string['copyrightstg'] = 'Mensaje de Propiedad';
$string['copyrightstgdesc'] = 'Aquí puede escribir el mensaje que aparecerá al final del pié de página, describiendo la propiedad del sitio Web.
Si deja en blanco esta opción, se compondrá un mensaje con el nombre corto del sitio y el año actual.
Recuerde que puede usar cualquiera de los modelos internacionalmente reconocidos:<br />
&nbsp;&nbsp;&nbsp; ► COPYRIGHT © AÑO EMPRESA &nbsp;&nbsp;&nbsp; ► EMPRESA © AÑO &nbsp;&nbsp;&nbsp; ► AÑO © EMPRESA';
$string['corpweb'] = 'Dirección Web';
$string['corpwebdesc'] = 'Introduzca aquí la dirección web de su Organización, Institución educativa o Empresa matriz. (ej.: http://www.dominio_empresa.es/) <br />
Esta dirección no tiene relación con ruta indicada en config.php';
$string['cortesyhead'] = 'Mensajes de cortesía';
$string['creditshead'] = 'Mensajes de crédito y mérito';
$string['css_color1'] = 'Azul Claro';
$string['css_color2'] = 'Azul Marino';
$string['css_color3'] = 'Verde Musgo';
$string['css_color4'] = 'Naranja';
$string['css_color5'] = 'Rojo Rubí';
$string['csshead'] = 'Personalización de la apariencia general (diseño CSS)';
$string['ctested_1'] = 'Validado con WIA CSS <a href="http://jigsaw.w3.org/css-validator/#validate_by_upload" target="_blank"> (WIA CSS) .</a>';
$string['ctested_2'] = 'Validado con WIA HTML 5.0 ó 4.0 <a href="http://validator.w3.org/check?uri=referer" target="_blank"> (WIA HTML 4.0) .</a>';
$string['ctested_3'] = 'Validado con WIA XHTML 1.0 <a href="http://validator.w3.org/check?uri=referer" target="_blank"> (WIA HTML 4.0) .</a>';
$string['ctested_4'] = 'reserved _ Cynthia Validator <a href="http://www.cynthiasays.com/" target="_blank"> (Cynthia) .</a>';
$string['ctested_5'] = 'reserved _ Children Free Validator <a href="http://www.w3.org/WAI/WCAG1AAA-Conformance" target="_blank"> (WAI WCAG AAA) .</a>';
$string['customcss'] = 'CSS personalizado';
$string['customcssdesc'] = 'Cualquiera que sean las normas CSS que añada a esta caja de texto se reflejarán en todas las páginas, lo que facilita la personalización de este tema.';
$string['custommenudesc'] = 'Para diseñar un menú personalizado y añadir los ítems necesarios, entre en Administración del sitio ► Apariencia ► Temas ► <a href="settings.php?section=themesettings">"Ajustes de temas"</a> ►  "custommenuitems"  .<br />
A continuación puede configurar los dos colores principales, las demas opciones deben ser configuradas directamente en el archivo css (aigne_menu.css).';
$string['custommenuhead'] = 'Opciones del menú personalizado';
$string['custommtag'] = 'Meta Etiquetas Personales';
$string['custommtagdesc'] = 'Si desea personalizar al máximo, puede añadir aquí las Meta Etiquetas que necesita.<br />
Por favor, tenga en cuenta el formato y el contenido, escribiendo el código entero, como lo haría en un editor Web, siguiendo el siguiente ejemplo:<br />
<pre>
&lt;META name="distribution" content="global" /&gt;
&lt;META name="revisit-after" content="31 Days" /&gt;
&lt;META name="robots" content="index,nofollow" /&gt;
</pre>';
$string['dailymotion'] = 'Enlace a DailyMotion';
$string['dailymotiondesc'] = 'Introduzca el enlace (URL) a su página en DailyMotion.
<a href="http://www.dailymotion.com/" target="_blank"> (www.dailymotion.com) .</a>';
$string['dayviews'] = 'Enlace a DayViews';
$string['dayviewsdesc'] = 'Introduzca el enlace (URL) a su página en DayViews.
<a href="http://dayviews.com/" target="_blank"> (dayviews.com) .</a>';
$string['decfontsizetxt'] = 'Pulse para disminuir el tamaño de la fuente. (Disminuir el tamaño del texto para mejorar la accesibilidad)';
$string['defaultfontsizetxt'] = 'Pulse para restaurar el tamaño de la fuente. (Recuperar el tamaño normal del diseño web)';
$string['defaultstyletxt'] = 'Pulse para recuperar el aspecto original del diseño web';
$string['deviantart'] = 'Enlace a DeviantArt';
$string['deviantartdesc'] = 'Introduzca el enlace (URL) a su cuenta en DeviantArt.
<a href="http://www.deviantart.com/" target="_blank"> (www.deviantart.com) .</a>';
$string['disclaimer'] = 'aviso legal';
$string['disclaimerdesc'] = 'Si activa esta opción, aparecerá un enlace en el pié de página al aviso legal obligatorio';
$string['disclaimerpage'] = '<h2 style="text-align: center">Esta es una página de muestra</h2>
<p>&nbsp;</p>
<h2>Información legal:</h2>
<p> El presente documento regula la utilización de los sitios Web adscritos al dominio de Internet
    "{$a->sitenamelow}.com"... o algo así.</p>
<h2>Parámetros que se pasan:</h2>
  <ul>{$a->sitenamelow}</ul>
  <ul>{$a->sitename}</ul>
  <ul>{$a->supportemail}</ul>
  <ul>{$a->sendadminemail}</ul>
  <p>&nbsp;</p>';
$string['dropbox'] = 'Enlace a DropBox';
$string['dropboxdesc'] = 'Introduzca el enlace (URL) a su cuenta en DropBox.
<a href="http://www.dropbox.com/" target="_blank"> (www.dropbox.com) .</a>';
$string['dublinmtag'] = 'Meta Etiquetas Dublin Core';
$string['dublinmtagdesc'] = 'Si activa esta opción, se generarán 3 etiquetas básicas (language, description, publisher) compatibles con el estándar "Dublin Core Metadata Initiative"';
$string['emailimg'] = 'Imagen para eMail';
$string['emailimgdesc'] = 'Aquí puede añadir una imagen con la dirección eMail de soporte. Esto ayudará a prevenir que herramientas maliciosas de spam capturen su dirección eMail. <br />
Configure esta dirección eMail en Administración del sitio ► Servidor ► <a href="settings.php?section=supportcontact">"Contacto de soporte"</a> ► "supportemail" .
Tenga en cuenta las proporciones en el diseño y añada una imagen de 32px de alto.';
$string['facebook'] = 'Enlace a Facebook';
$string['facebookdesc'] = 'Introduzca el enlace (URL) a su página en Facebook.
<a href="http://www.facebook.com/" target="_blank"> (www.facebook.com) .</a>';
$string['flickr'] = 'Enlace a Flickr';
$string['flickrdesc'] = 'Introduzca el enlace (URL) a su página en Flickr.
<a href="http://www.flickr.com" target="_blank"> (www.flickr.com) .</a>';
$string['footnote'] = 'Nota al pié de página';
$string['footnotedesc'] = 'Si desea puede añadir contenido personalizado en el pié de página. Este contenido será insertado a continuación de la zona de créditos.';
$string['footsearch'] = 'búsqueda';
$string['footsearchdesc'] = 'Si activa esta opción, aparecerá un enlace en el pié de página a la búsqueda general dentro de la plataforma';
$string['footsearchpage'] = '<h2 style="text-align: center">Esta es una página de muestra</h2>
<p>&nbsp;</p>
<h2>Buscar:</h2>
  <p>Aquí puede introducir herramientas generales de búsqueda.</p>
  <p>&nbsp;</p>';
$string['fotolog'] = 'Enlace a FotoLog';
$string['fotologdesc'] = 'Introduzca el enlace (URL) a su página en FotoLog.
<a href="http://www.fotolog.com/" target="_blank"> (www.fotolog.com) .</a>';
$string['googleplus'] = 'Enlace a Google+';
$string['googleplusdesc'] = 'Introduzca el enlace (URL) a su perfil en Google+.
<a href="http://plus.google.com/" target="_blank"> (plus.google.com) .</a>';
$string['headbanner'] = 'Mostrar Banner del Encabezado';
$string['headbannerdesc'] = 'Si activa esta opción, se mostrará una imagen en la cabecera de la página principal, antes que los usuarios se identifiquen.';
$string['headerinfo'] = 'Encabezado de presentación';
$string['headerinfodesc'] = 'Si lo desea puede añadir una imagen fija en la cabecera de la página principal, antes que los usuarios se identifiquen.<br />
Debe ser una imagen JPG/PNG/GIF con un mínimo de 775px de largo y 100px de alto.';
$string['help'] = 'ayuda';
$string['helpdesc'] = 'Si activa esta opción, aparecerá un enlace en el pié de página a la ayuda general de la plataforma';
$string['helppage'] = '<h2 style="text-align: center">Esta es una página de muestra</h2>
<p>&nbsp;</p>
<h2>Ayuda a la navegación:</h2>
  <p>Aquí puede introducir todas las referencias necesarias para facilitar la
     navegación por sus cursos. Además, puede crear una sección para enlazar con
     el "Manual del alumnado" o manuales de utilización.</p>
<h2>Moodle:</h2>
  <p>Nuestra plataforma de enseñanza está basada en Moodle. Si desea ampliar
     información sobre la usabilidad de Moodle, puede acceder a los
     <a href="http://docs.moodle.org">documentos de ayuda oficiales</a>.</p>
<h2>Parámetros que se pasan:</h2>
  <ul>{$a->link}</ul>
  <ul>{$a->supportemail}</ul>
  <ul>{$a->sendadminemail}</ul>
  <p>&nbsp;</p>';
$string['incfontsizetxt'] = 'Pulse para aumentar el tamaño de la fuente. (Aumentar el tamaño del texto para mejorar la accesibilidad)';
$string['instagram'] = 'Enlace a Instagram';
$string['instagramdesc'] = 'Introduzca el enlace (URL) a su página en Instagram.
<a href="http://instagram.com/" target="_blank"> (instagram.com) .</a>';
$string['lastmodifiedmsg'] = 'Última actualización';
$string['lastmodifiedmsgdesc'] = 'Si desea que aparezca un mensaje al final del pié de página con la fecha de actualización del sitio web, active esta opción';
$string['lastpageupdate'] = 'Esta página fue modificada por última vez en';
$string['linkedin'] = 'Enlace a LinkedIn';
$string['linkedindesc'] = 'Introduzca el enlace (URL) a su perfil en LinkedIn.
<a href="http://www.linkedin.com/" target="_blank"> (www.linkedin.com) .</a>';
$string['logo'] = 'Logotipo';
$string['logodesc'] = 'Si lo desea puede añadir un logotipo personalizado.<br />
El logotipo debe ser una imagen JPG/PNG/GIF con 150px de largo y 55px de alto';
$string['logohead'] = 'Configuración del logotipo';
$string['marketinghead'] = 'Opciones de diseño en la página de presentación del sitio (frontpage _ marketing)';
$string['marketingheaddesc'] = '::: en construcción :::';
$string['menucolor'] = 'Color del menú personalizado';
$string['menucolordesc'] = 'Seleccione el color de fondo del menú personalizado. Las demás opciones deben ser configuradas directamente en el archivos css (aigne_menu.css).';
$string['menucolorhl'] = 'Color de contraste del menú personalizado';
$string['menucolorhldesc'] = 'Seleccione el color de contraste del menú personalizado. Tenga en cuenta la combinación con el anterior color para mentener un diseño agradable';
$string['metadescription'] = 'Bienvenido a {$a->sitename}.';
$string['metakeywords'] = 'aigne, formación, educación, enseñanza, pedagogía';
$string['moodlecredit'] = 'Créditos a Moodle';
$string['moodlecreditdesc'] = 'Si desea que aparezca en el pié de página un mensaje de agradecimiento y un enlace a la página original de <a href="http://moodle.org/" target="_blank">moodle.org.</a>, active esta opción';
$string['morning_greeting'] = 'Buenos días... !';
$string['mtaghead'] = 'Opciones de las Meta Etiquetas';
$string['mtagheaddesc'] = 'Las Meta Etiquetas pueden ser utilizadas para mejorar el posicionamiento en algunos buscadores, así como ofrecer
información fiable sobre nuestro sitio a multitud de servicios de indexación y clasificación que rondan por Internet.';
$string['mtdescription'] = 'Meta Etiqueta Description';
$string['mtdescriptiondesc'] = 'Si lo desea puede escribir un contenido personalizado para la Meta Etiqueta "description".<br />
Por favor, tenga en cuenta el formato y el contenido, añadiendo un máximo de 250 caracteres<br />
Si deja en blanco esta opción, se generará una expresión de bienvenida según el idioma';
$string['mtkeywords'] = 'Meta Etiqueta Keywords';
$string['mtkeywordsdesc'] = 'Si lo desea puede escribir un contenido personalizado para la Meta Etiqueta "keywords".<br />
Por favor, tenga en cuenta el formato y el contenido, separando las palabras por coma y añadiendo un máximo de 25 palabras.<br />
Si deja en blanco esta opción, se generará una expresión automática con 5 palabras según el idioma';
$string['myspace'] = 'Enlace a MySpace';
$string['myspacedesc'] = 'Introduzca el enlace (URL) a su perfil en MySpace.
<a href="http://www.myspace.com/" target="_blank"> (www.myspace.com) .</a>';
$string['navhelp'] = 'Enlace de la ayuda a la navegación';
$string['navhelpdesc'] = 'Dirección de la página donde están configuradas las opciones de la barra de ayuda a la navegación';
$string['navhelphead'] = 'Opciones de ayuda a la navegación';
$string['navhelppage'] = 'Página de ayuda';
$string['navhelppagetitle'] = 'Ayuda a la navegación';
$string['night_greeting'] = 'Buenas noches... !';
$string['nocontentdrag'] = 'Debido a la protección del copyright de nuestros cursos, esta deshabilitado arrastrar (drag & drop) algunos contenidos';
$string['nocontentprint'] = '<h2 style="text-align: center">Prevención de impresión</h2>
<h3><b>Copyright:</b></h3>
  <p>Todo el contenido de {$a->sitename} está amparado por la legislación vigente
     que protege los derechos de autor. Si desea obtener más información,
     visite nuestra página de {$a->disclaimer}.</p>
  <p>&nbsp;</p>
<h3><b>Impresión:</b></h3>
  <p>Para evitar posibles fraudes en la utilización del contenido de nuestros
     cursos, se han instalado algunas herramientas básicas para prevenir la
     impresión de ese contenido y proteger dichos derechos de autor.</p>
  <p>&nbsp;</p>
<h3><b>Obtener una copia:</b></h3>
  <p>Si usted está matriculado en alguno de nuestros cursos y necesita una
     copia del contenido, que no esté incluida en el proprio curso, póngase en
     contacto con su Profesor o con el Administrador del Sitio para obtener
     ayuda sobre el tema.</p>
  <p>&nbsp;</p>
<hr>
  <p style="text-align: center">Disculpe las molestias.</p>';
$string['nocontentselect'] = 'Debido a la protección del copyright de nuestros cursos, esta deshabilitado seleccionar (copy & paste) algunos contenidos';
$string['noimplemented'] = 'Opción no implementada. Disculpe las molestías';
$string['notes'] = 'Notas del tema aigne';
$string['notesdesc'] = 'Para aplicar cualquier cambio en la configuración presione "Guardar cambios" al final de la página. Si no tiene habilitado el "Modo de diseño de temas", quizás necesite forzar la actualización entrando en Administración del sitio ► Desarrollo ►  <a href="purgecaches.php">"Purgar todas las Cachés"</a>.';
$string['optionalmtag'] = 'Meta Etiquetas Opcionales';
$string['optionalmtagdesc'] = 'Si activa esta opción, se generarán Meta Etiquetas adicionales, con información automática sobre su sitio.';
$string['original_theme'] = 'Diseño inspirado en un tema original de Patrick Malley & Mary Evans';
$string['orkut'] = 'Enlace a Orkut';
$string['orkutdesc'] = 'Introduzca el enlace (URL) a su perfil en Orkut.
<a href="http://www.orkut.com/" target="_blank"> (www.orkut.com) .</a>';
$string['outbutton'] = 'Opción de salir al estilo de botón';
$string['outmoodle'] = 'Opción de salir al estilo moodle, con un enlace';
$string['outnone'] = 'Sin la opción de salir';
$string['picasa'] = 'Enlace a Picasa';
$string['picasadesc'] = 'Introduzca el enlace (URL) a su página en Picasa.
<a href="http://picasa.google.com/" target="_blank"> (picasa.google.com) .</a>';
$string['pinterest'] = 'Enlace a Pinterest';
$string['pinterestdesc'] = 'Introduzca el enlace (URL) de su página en Pinterest.
<a href="http://pinterest.com/" target="_blank"> (pinterest.com) .</a>';
$string['pixabay'] = 'Enlace a PixaBay';
$string['pixabaydesc'] = 'Introduzca el enlace (URL) a su página en PixaBay.
<a href="http://pixabay.com/" target="_blank"> (pixabay.com) .</a>';
$string['pluginname'] = 'aigne';
$string['policies'] = 'política del sitio';
$string['policiesdesc'] = 'Si activa esta opción, aparecerá un enlace en el pié de página a las política generales de la plataforma';
$string['policiespage'] = '<h2 style="text-align: center">Esta es una página de muestra</h2>
<p>&nbsp;</p>
<h2>Politicas del sitio:</h2>
  <p>Aquí puede introducir las políticas de uso del sitios web, los deberes y derechos
     de los alumnos, .</p>
  <p>&nbsp;</p>';
$string['powered'] = 'Con la potencia de:';
$string['privacy'] = 'privacidad';
$string['privacydesc'] = 'Si activa esta opción, aparecerá un enlace en el pié de página a la información sobre la privacidad en la navegación dentro de la plataforma';
$string['privacypage'] = '<h2 style="text-align: center">Esta es una página de muestra</h2>
<p>&nbsp;</p>
<h2>Privacidad de los datos de usuario y alumnos</h2>
<p>Aquí puede introducir la información sobre la privacidad de los datos en la navegación
   por el sitio web, además de las diferentes clausulas legales obligatorias.</p>
<h2>Parámetros que se pasan:</h2>
  <ul>{$a->sitenamelow}</ul>
  <ul>{$a->supportemail}</ul>
  <ul>{$a->sendadminemail}</ul>
  <ul>{$a->remoteaddr}</ul>
  <ul>{$a->remotehost}</ul>
  <ul>{$a->remoteuser}</ul>
  <ul>{$a->language}</ul>
  <ul>{$a->useragent}</ul>
  <ul>{$a->referer}</ul>
  <p>&nbsp;</p>';
$string['region-side-post'] = 'Derecha';
$string['region-side-pre'] = 'Izquierda';
$string['reservedrights'] = 'Reservados todos los derechos';
$string['schooltube'] = 'Enlace a SchoolTube';
$string['schooltubedesc'] = 'Introduzca el enlace (URL) a su página en SchoolTube.
<a href="https://www.schooltube.com/" target="_blank"> (www.schooltube.com) .</a>';
$string['security'] = 'seguridad';
$string['securitydesc'] = 'Si activa esta opción, aparecerá un enlace en el pié de página a la información sobre la seguridad en la navegación dentro de la plataforma';
$string['securitypage'] = '<h2 style="text-align: center">Esta es una página de muestra</h2>
<p>&nbsp;</p>
<h2>Seguridad:</h2>
<p>Aquí puede introducir las medidas de seguridad que se utilizan para prevenir el SPAM,
   la herramientas antivirus y los procedimientos de copia de seguridad.</p>
  <p>&nbsp;</p>';
$string['sep_bhr'] = '<br /><hr>';
$string['sep_br'] = '<br />';
$string['sep_hr'] = '<hr>';
$string['sep_hr2'] = '<hr width="50%" align="center">';
$string['sitelicensemsg'] = 'Tipo de licencia';
$string['sitelicensemsgdesc'] = 'Si desea que aparezca un mensaje al final del pié de página con el tipo de licencia que rige el contenido de este sitio, active esta opción.<br />
El tipo de licencia se puede configurar en Administración del sitio ► Extensiones ► Licencias ► <a href="settings.php?section=managelicenses">"Administrar licencias"</a> ► "sitedefaultlicense"  .';
$string['skype'] = 'Cuenta de Skype';
$string['skypedesc'] = 'Introduzca el nombre de usuario de su Organización / Institución educativa / Empresa matriz, en la red de Skype.';
$string['slogan'] = 'Lema';
$string['sloganaigne'] = 'aigne';
$string['slogandesc'] = 'Si lo desea puede añadir una pequeña frase que aparecerá bajo el logotipo, en forma de lema.<br />
Tenga en cuenta el tamaño de la frase para mantener el diseño del encabezado.';
$string['socialcontenthead'] = 'Enlaces a las direcciones de las redes sociales, donde comparte contenido';
$string['socialhead'] = 'Enlaces a las direcciones propias de las redes sociales';
$string['sociallinks'] = '... y en las Redes Sociales:';
$string['stats'] = 'estadísticas';
$string['statsdesc'] = 'Si activa esta opción, aparecerá un enlace en el pié de página a las estadísticas de uso de la plataforma';
$string['statspage'] = '<h2 style="text-align: center">Esta es una página de muestra</h2>
<p>&nbsp;</p>
<h2>Estadísticas:</h2>
  <p>Aquí puede introducir los resultados de estadísticas de navegación o
     informes de avaliación de la formación dentro de su organización.</p>
  <p>&nbsp;</p>';
$string['styletxt'] = 'Pulse para aplicar una combinación de colores diferente al diseño web';
$string['thanksvisit'] = 'Gracias por su confianza';
$string['thanksvisitmsg'] = 'Mensaje de agradecimiento';
$string['thanksvisitmsgdesc'] = 'Si desea que aparezca un mensaje de agradecimiento al final del pié de página, active esta opción';
$string['tumblr'] = 'Enlace a Tumblr';
$string['tumblrdesc'] = 'Introduzca el enlace (URL) a su blog en Tumblr.
<a href="http://tumblr.com/" target="_blank"> (tumblr.com) .</a>';
$string['twitter'] = 'Enlace a Twitter';
$string['twitterdesc'] = 'Introduzca el enlace (URL) a su cuenta de Twitter.
<a href="http://twitter.com/" target="_blank"> (twitter.com) .</a>';
$string['useraigne'] = 'En el Encabezado, al estilo aigne (login + saludo + usuario + foto + logout)';
$string['usermoodle'] = 'En el Encabezado, al estilo estándar de moodle (login + usuario + logout)';
$string['usernav'] = 'Area de Información del Usuario.';
$string['usernavdesc'] = 'Seleccione el modo que aparecerá la información del usuario en el encabezado.';
$string['usernavhead'] = 'Opciones del area de Información del Usuario';
$string['usernavheaddesc'] = 'Las siguientes opciones configuran la información que aparecerá en el area de Información del Usuario, si selecciona el estilo aigne.
Recuerde que el Area de Información del Usuario al estilo moodle es estándar y tiene un formato fijo.<br />
Si desea que además aparezca la casilla para recordar usuario, vaya a Administración del sitio ► Seguridad ► Políticas del sitio ► "rememberusername"';
$string['usernavinfo'] = 'Nombre del usuario';
$string['usernavinfodesc'] = 'Si activa esta opción, aparecerá el nombre del usuario en el area de Información del Usuario en el encabezado.';
$string['usernavout'] = 'Botón de salida';
$string['usernavoutdesc'] = 'Si activa esta opción, aparecerá un botón de salida de la plataforma en el area de Información del Usuario en el encabezado.';
$string['usernavpic'] = 'Foto del usuario';
$string['usernavpicdesc'] = 'Si activa esta opción, aparecerá una foto del usuario en el area de Información del Usuario en el encabezado.';
$string['usernavsalut'] = 'Saludo';
$string['usernavsalutdesc'] = 'Si activa esta opción, aparecerá un saludo condicional en el area de Información del Usuario en el encabezado.';
$string['usernone'] = 'Sin ningún tipo de información del usuario';
$string['videolog'] = 'Enlace a VideoLog';
$string['videologdesc'] = 'Introduzca el enlace (URL) a su página en VideoLog.
<a href="http://videolog.tv/" target="_blank"> (videolog.tv) .</a>';
$string['vimeo'] = 'Enlace a Vimeo';
$string['vimeodesc'] = 'Introduzca el enlace (URL) a su canal en Vimeo.
<a href="http://www.vimeo.com/" target="_blank"> (www.vimeo.com) .</a>';
$string['vkontakte'] = 'Enlace a VKontakte';
$string['vkontaktedesc'] = 'Introduzca el enlace (URL) de su página en Vkontakte.
<a href="http://www.vk.com/" target="_blank"> (www.vk.com) .</a>';
$string['webmap'] = 'mapa web';
$string['webmapdesc'] = 'Si activa esta opción, aparecerá un enlace en el pié de página al Esquema de páginas de la plataforma, que formará el Mapa Web';
$string['webmappage'] = '<h2 style="text-align: center">Esta es una página de muestra</h2>
<p>&nbsp;</p>
<p>Aquí puede crear un mapa con la estructura de páginas que necesita
   para dar a conocer su organización, sus filosofía de trabajo y el
   equipo humano que conforma su proyecto formativo.</p>
<h2>Parámetros que se pasan:</h2>
  <ul>{$a->sitename}</ul>
<p>&nbsp;</p>';
$string['welcomemsg'] = 'Mensaje de bienvenida personalizado';
$string['welcomemsgdesc'] = 'Defina un mensaje de bienvenida, que será mostrado en el area de Información del Usuario en el encabezado';
$string['youtube'] = 'Enlace a YouTube';
$string['youtubedesc'] = 'Introduzca el enlace (URL) a su canal en YouTube.
<a href="http://www.youtube.com/" target="_blank"> (www.youtube.com) .</a>';
